#ifndef SCRIPTSMANAGER_H
#define SCRIPTSMANAGER_H

class ScriptManager {
public:	
	
	class PythonScript : public ScriptImpClass {
		
		void Created(GameObject *obj);
		void Destroyed(GameObject *obj);
		void Killed(GameObject *obj,GameObject *shooter);
		void Damaged(GameObject *obj,GameObject *damager,float damage);
		void Custom(GameObject *obj,int message,int param,GameObject *sender);
		void Enemy_Seen(GameObject *obj,GameObject *seen);
		void Action_Complete(GameObject *obj,int action,ActionCompleteReason reason);
		void Timer_Expired(GameObject *obj,int number);
		void Animation_Complete(GameObject *obj,const char *anim);
		void Poked(GameObject *obj,GameObject *poker);
		void Entered(GameObject *obj,GameObject *enter);
		void Exited(GameObject *obj,GameObject *exit);
	};
	struct Script
	{
		ScriptRegistrant<PythonScript> *scriptreg;
		PyObject* classobject;
		char name[256];
		char params[256];
	};
	
	static Script *Scripts[256];
	static ScriptImpClass *Get_Script(GameObject *obj, int scriptID);
	//static bool Report_Errors(lua_State *L, int status);

	//static int Lua_DestroyScript_Wrap(lua_State *L);
	//static int Lua_Get_Float_Parameter_Wrap(lua_State *L);
	//static int Lua_Get_Int_Parameter_Wrap(lua_State *L);
	//static int Lua_Get_String_Parameter_Wrap(lua_State *L);
	//static int Lua_Start_Timer_Wrap(lua_State *L);

	

	static void Load();
	static PyCFunction* registerscript(PyObject *self, PyObject *args);
	static void Lua_DestroyScript(GameObject *obj, int scriptID);
	static float Lua_Get_Float_Parameter(GameObject *obj, int scriptID, const char *Name);
	static int Lua_Get_Int_Parameter(GameObject *obj, int scriptID, const char *Name);
	static const char *Lua_Get_String_Parameter(GameObject *obj, int scriptID, const char *Name);
	static void Lua_Start_Timer(GameObject *obj, int scriptID, float Time, int Number);
	static void Cleanup();
};

extern PyObject *ModulesArray[];
extern int ModulesArrayIndex;

#endif